#ifndef NAGLG05

#define NAGLG05



/* <naglg05.h>

 *

 * Copyright 1991 Numerical Algorithms Group

 *

 * Local header file for G05 chapter of the NAG C Library.

 * This header file is not intended for Library users.

 *

 * This header file was generated by getcons.

 *

 * Mark 6a, 2001.

 */



/*   Machine dependent constants for NAG random number

 *   generator routines.

 *

 *************** ADVICE FOR IMPLEMENTORS *************

 *

 * An appropriate value for the constant G05C_ILIM is

 * required for the basic random number generator routines

 * g05cay, g05caz, g05cbc, g05ccc, g05cfz and g05cgz. These

 * notes are intended to help implementors choose the

 * appropriate value of G05C_ILIM if the value obtained by

 * the tool getcons is deemed to be inappropriate. Decide

 * the relevant value of G05C_ILIM, say nn, taking account

 * of the suggestion for 'long' integers as detailed below.

 * Please follow these guidelines and consult NAG Central

 * Office if in any doubt or difficulty.

 *

 * The algorithm requires that the values of n and of the

 * multiplier 13**13 be stored as 59-bit unsigned integers

 * and that the least significant 59 bits of their product

 * be computed.

 *

 * The 59-bit integer n is stored as a multiple-length

 * integer in the array b. In fact for convenience the

 * 60-bit integer 2*n is stored. The multiplier 13**13

 * is stored in the array m.

 * The multiplier (13**13)**63 modulo 2**59 is stored in

 * the array mlv in exactly the same way as the basic

 * multiplier is stored in the array m.

 *

 * The number of elements in n and m (G05C_ILIM) and the

 * number of bits used in each element of n and m (BITS)

 * depend on the number of bits (including sign) in an

 * integer variable as follows -

 *

 *  G05C_ILIM   BITS  number of bits in integer variable

 *      4        15                 >= 32

 *      3        20                 >= 41

 *      2        30                 >= 60

 *

 * For greatest efficiency G05C_ILIM should be chosen as

 * small as possible.

 *

 * N.B. the most significant bits of n are stored in

 * b[G05C_ILIM-1][i], the next most significant bits in

 * b[G05C_ILIM-1][i-1], . . . , and the least significant

 * bits in b[G05C_ILIM-1][0]. The multiplier is stored

 * in m[G05C_ILIM-1], m[ILIM-2], . . . , m[0] in the same

 * way.

 *

 * Note -

 *

 * 1) In the above table the value of BITS is less than

 *    half the number of bits in an integer variable. This

 *    ensures that the necessary integer products can be

 *    formed and summed correctly without integer overflow.

 *    However many machines have instructions for forming

 *    double-length integer products.  A machine code

 *    implementation can take advantage of this and allow

 *    BITS to be as large (or almost as large) as the

 *    number of bits in an integer variable and G05C_ILIM

 *    to be correspondingly smaller. This should be more

 *    efficient.

 *

 * 2) The figures in the rightmost column in the above

 *    table are correct for the specific value of the

 *    multiplier. They are certainly not correct for

 *    arbitrary 60-bit arithmetic.

 *

 * 3) It may well be advantageous to use 'long long'

 *    integers, if available, within g05cay, even if they

 *    are not used elsewhere in the library.

 *

 * The symbol G05C_LV is defined as the value 63.

 * This particular value was chosen because of special

 * properties of the multiplier (13**13)**63 modulo 2**59,

 * which permit efficient multi-length arithmetic when

 * G05C_ILIM = 4 (see below). Only a few values of G05C_LV

 * have such properties.

 *

 */



#define G05C_LV 63

#define G05C_ILIM 4



/* define global variables */

typedef struct

  {

    Integer b[G05C_ILIM][G05C_LV+1], option, possop, defopt;

  } Nag_ag05ca_type;



typedef struct

  {

    double normal, gamma;

  } Nag_bg05ca_type;



typedef struct

  {

    double  rv[G05C_LV];

    Integer kv;

  } Nag_cg05ca_type;



typedef struct

  {

    double vnorml;

  } Nag_dg05ca_type;





/* External variables */



extern NAG_DLL_EXPIMP Nag_ag05ca_type ag05ca;

extern NAG_DLL_EXPIMP Nag_bg05ca_type bg05ca;

extern NAG_DLL_EXPIMP Nag_cg05ca_type cg05ca;

extern NAG_DLL_EXPIMP Nag_dg05ca_type dg05ca;



#endif  /* not NAGLG05 */

